unit GridEditor01;

interface
uses SysUtils, Dialogs, Grids,
     MainDef;

//       
function TextToInt (Text : string; var Digit : integer): boolean;

//    OnSetEditText   TStringGrid
//   GRID    T2DIntegerArray
procedure EditInGrid2DIntegerArray(Sender      : TObject;
                                   ACol, ARow  : Integer;
                                   const Value : String;
                                   var RqArray : T2DIntegerArray);

implementation

//-------------------------------------------------------------------------
// 26.10.2008
//       
function TextToInt (Text : string; var Digit : integer): boolean;
begin
  try
    Digit := StrToInt(Text);
    TextToInt := True;
  except
    Digit := 0;
    TextToInt := False;
  end;
end; // of function

//-----------------------------------------------------------
// 17.10.2009
//    OnSetEditText   TStringGrid
//   GRID    T2DIntegerArray
procedure EditInGrid2DIntegerArray(Sender      : TObject;
                                   ACol, ARow  : Integer;
                                   const Value : String;
                                   var RqArray : T2DIntegerArray);
var WD : integer;
begin
       //---------------------------------
       //    Grid
       if Sender is TStringGrid
       then begin
         with TStringGrid(Sender) do
         begin
           //---------------------------------
           if Cells[ACol, ARow] <> '-'
           //     
           then begin
             if Cells[ACol, ARow] <> ''
             //    (  )
             then begin
                 //     
                 if TextToInt (Cells[ACol, ARow], WD)
                 then begin
                     //     
                     //     RqArray
                     RqArray[ACol, ARow]:= WD;
                 end
                 else begin
                    MessageDlg( ' : : ' + Value
                     + #13#10 + '    .'
                     + #13#10 + ' :   .',
                     mtWarning, [mbOk], 0);
                    //   
                    if RqArray[ACol, ARow] = 0
                    then Cells[ACol, ARow] := ''
                    else Cells[ACol, ARow] := IntToStr(RqArray[ACol, ARow]);
                 end;
             end
             else begin
                //    
                RqArray[ACol, ARow] := 0;
             end;  {of if Value <> '' }
           end
           else begin
                //     
                RqArray[ACol, ARow] := 0;
           end;  // of if Value <> '-'
         end; // of with TStringGrid(Sender)
       end;  // of if Sender is TStringGrid
end; // of procedure



end.
